/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.api.VWException;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.exprcomp.IDistributions;
import filenet.vw.base.exprcomp.IField;
import filenet.vw.base.exprcomp.IFieldCollection;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;

class OpCode {
    public static final int DTNoType = -1;
    public static final int UnknownDataType = -2;
    public static final int ArrayTypeInteger = -3;
    public static final int ArrayTypeFloat = -4;
    public static final int ArrayTypeString = -5;
    public static final int ArrayTypeAttachment = -6;
    public static final int ArrayTypeParticipant = -7;
    public static final int ArrayTypeTime = -8;
    public static final int ArrayTypeBoolean = -9;
    public static final int ArrayTypeXML = -10;
    public static final int ArrayTypeGuid = -11;
    public static final int UnsLongLitOpCode = 1;
    public static final int BeginSubScriptOpCode = 2;
    public static final int DoubleLitOpCode = 3;
    public static final int StringLitOpCode = 4;
    public static final int TrueOpCode = 5;
    public static final int FalseOpCode = 6;
    public static final int FieldDefined1FuncOpCode = 7;
    public static final int FieldDefined2FuncOpCode = 8;
    public static final int IsValidFuncOpCode = 9;
    public static final int ValueOpCode = 10;
    public static final int FNNumberLitOpCode = 11;
    public static final int IdentOpCode = 12;
    public static final int FieldOpCode = 13;
    public static final int SubScriptOpCode = 14;
    public static final int OrOpCode = 15;
    public static final int AndOpCode = 16;
    public static final int NotOpCode = 17;
    public static final int EQOpCode = 18;
    public static final int NEOpCode = 19;
    public static final int GTOpCode = 20;
    public static final int LTOpCode = 21;
    public static final int GEOpCode = 22;
    public static final int LEOpCode = 23;
    public static final int AddOpCode = 24;
    public static final int SubtractOpCode = 25;
    public static final int MultiplyOpCode = 26;
    public static final int DivideOpCode = 27;
    public static final int NegateOpCode = 28;
    public static final int IntFuncOpCode = 29;
    public static final int AbsFuncOpCode = 30;
    public static final int ModFuncOpCode = 31;
    public static final int MinFuncOpCode = 32;
    public static final int MaxFuncOpCode = 33;
    public static final int LenFuncOpCode = 34;
    public static final int StrInsFuncOpCode = 35;
    public static final int StrLocFuncOpCode = 36;
    public static final int SubStr2FuncOpCode = 37;
    public static final int TranslateFuncOpCode = 38;
    public static final int UpperFuncOpCode = 39;
    public static final int LowerFuncOpCode = 40;
    public static final int TrimFuncOpCode = 41;
    public static final int LTrimFuncOpCode = 42;
    public static final int RTrimFuncOpCode = 43;
    public static final int RepeatFuncOpCode = 44;
    public static final int InSetFuncOpCode = 45;
    public static final int SubstituteFuncOpCode = 46;
    public static final int IsNumberFuncOpCode = 47;
    public static final int IsDateFuncOpCode = 48;
    public static final int IsTimeFuncOpCode = 49;
    public static final int IsNullFuncOpCode = 50;
    public static final int ConvertOpCode = 51;
    public static final int DateToStringFuncOpCode = 52;
    public static final int StringToDateFuncOpCode = 53;
    public static final int TimeToStringFuncOpCode = 54;
    public static final int StringToTimeFuncOpCode = 55;
    public static final int NumberToStringFuncOpCode = 56;
    public static final int AddSecondsFuncOpCode = 57;
    public static final int AddMinutesFuncOpCode = 58;
    public static final int AddHoursFuncOpCode = 59;
    public static final int AddDaysFuncOpCode = 60;
    public static final int AddMonthsFuncOpCode = 61;
    public static final int AddYearsFuncOpCode = 62;
    public static final int DaysBetweenFuncOpCode = 63;
    public static final int SecondsBetweenFuncOpCode = 64;
    public static final int WeekDayFuncOpCode = 65;
    public static final int SystemDateFuncOpCode = 66;
    public static final int SystemTimeFuncOpCode = 67;
    public static final int CreateCollectionOpCode = 68;
    public static final int HexFuncOpCode = 69;
    public static final int ErrorEncodeFuncOpCode = 70;
    public static final int BitAndFuncOpCode = 71;
    public static final int BitOrFuncOpCode = 72;
    public static final int BitNotFuncOpCode = 73;
    public static final int ColorFuncOpCode = 74;
    public static final int RedFuncOpCode = 75;
    public static final int GreenFuncOpCode = 76;
    public static final int BlueFuncOpCode = 77;
    public static final int SizeOfFuncOpCode = 78;
    public static final int NullFuncOpCode = 79;
    public static final int IfFuncOpCode = 80;
    public static final int GotoOpCode = 81;
    public static final int SubStr3FuncOpCode = 82;
    public static final int AddToCollectionOpCode = 83;
    public static final int AltFieldDefinedFuncOpCode = 84;
    public static final int UserIdFuncOpCode = 85;
    public static final int RandomFuncOpCode = 86;
    public static final int Trim1FuncOpCode = 87;
    public static final int LTrim1FuncOpCode = 88;
    public static final int RTrim1FuncOpCode = 89;
    public static final int EndSubScriptOpCode = 90;
    public static final int EnvFieldFuncOpCode = 91;
    public static final int SystemEnvFieldFuncOpCode = 92;
    public static final int UserEnvFieldFuncOpCode = 93;
    public static final int DistBernoulliFuncOpCode = 94;
    public static final int DistBetaFuncOpCode = 95;
    public static final int DistBinomialFuncOpCode = 96;
    public static final int DistExponentialFuncOpCode = 97;
    public static final int DistGammaFuncOpCode = 98;
    public static final int DistGeometricFuncOpCode = 99;
    public static final int DistLognormalFuncOpCode = 100;
    public static final int DistNormalFuncOpCode = 101;
    public static final int DistPoissonFuncOpCode = 102;
    public static final int DistUniformFuncOpCode = 103;
    public static final int DistWeibullFuncOpCode = 104;
    public static final int XmlInsertBeforeFuncOpCode = 105;
    public static final int XmlInsertAfterFuncOpCode = 106;
    public static final int XmlInsertChildFirstFuncOpCode = 107;
    public static final int XmlInsertChildLastFuncOpCode = 108;
    public static final int XmlRemoveFuncOpCode = 109;
    public static final int XmlRenameFuncOpCode = 110;
    public static final int XmlBooleanExprFuncOpCode = 111;
    public static final int XmlIntegerExprFuncOpCode = 112;
    public static final int XmlFloatExprFuncOpCode = 113;
    public static final int XmlStringExprFuncOpCode = 114;
    public static final int XmlTransformFuncOpCode = 115;
    public static final int IsWellFormedFuncOpCode = 116;
    public static final int IsValidXMLFuncOpCode = 117;
    public static final int ElementCountFuncOpCode = 118;
    public static final int NextElementFuncOpCode = 119;
    public static final int AttachmentFuncOpCode = 120;
    public static final int XmlStringArrayExprFuncOpCode = 121;
    public static final int ArrayToStringFuncOpCode = 122;
    public static final int EncodeFuncOpCode = 123;
    public static final int DecodeFuncOpCode = 124;
    public static final int XmlEncodeFuncOpCode = 125;
    public static final int XmlDecodeFuncOpCode = 126;
    public static final int PropertyOpCode = 127;
    protected int opCode = 0;
    private int theOpCodeValue = 0;
    static String[] opCodeNames = new String[]{"invalid OpCode", "UnsLongLit", "BeginSubScript", "DoubleLit", "StringLit", "True", "False", "FieldDefined1Func", "FieldDefined2Func", "IsValidFunc", "Value", "FNNumberLit", "Ident", "Field", "SubScript", "Or", "And", "Not", "EQ", "NE", "GT", "LT", "GE", "LE", "Add", "Subtract", "Multiply", "Divide", "Negate", "IntFunc", "AbsFunc", "ModFunc", "MinFunc", "MaxFunc", "LenFunc", "StrInsFunc", "StrLocFunc", "SubStr2Func", "TranslateFunc", "UpperFunc", "LowerFunc", "TrimFunc", "LTrimFunc", "RTrimFunc", "RepeatFunc", "InSetFunc", "SubstituteFunc", "IsNumberFunc", "IsDateFunc", "IsTimeFunc", "IsNullFunc", "ConvertFunc", "DateToStringFunc", "StringToDateFunc", "TimeToStringFunc", "StringToTimeFunc", "NumberToStringFunc", "AddSecondsFunc", "AddMinutesFunc", "AddHoursFunc", "AddDaysFunc", "AddMonthsFunc", "AddYearsFunc", "DaysBetweenFunc", "SecondsBetweenFunc", "WeekDayFunc", "SystemDateFunc", "SystemTimeFunc", "CreateCollection", "HexFunc", "ErrorEncodeFunc", "BitAndFunc", "BitOrFunc", "BitNotFunc", "ColorFunc", "RedFunc", "GreenFunc", "BlueFunc", "SizeOfFunc", "NullFunc", "IfFunc", "Goto", "SubStr3Func", "AddToCollection", "AltFieldDefinedFunc", "UserIdFunc", "RandomFunc", "Trim1Func", "LTrim1Func", "RTrim1Func", "EndSubScript", "EnvFieldFunc", "SystemEnvFieldFunc", "UserEnvFieldFunc", "DistBernoulliFunc", "DistBetaFunc", "DistBinomialFunc", "DistExponentialFunc", "DistGammaFunc", "DistGeometricFunc", "DistLognormalFunc", "DistNormalFunc", "DistPoissonFunc", "DistUniformFunc", "DistWeibullFunc", "XmlInsertBeforeFunc", "XmlInsertAfterFunc", "XmlInsertChildFirstFunc", "XmlInsertChildLastFunc", "XmlRemoveFunc", "XmlRenameFunc", "XmlBooleanExprFunc", "XmlIntegerExprFunc", "XmlFloatExprFunc", "XmlStringExprFunc", "XmlTransformFunc", "IsWellFormedFunc", "IsValidXMLFunc", "ElementCountFunc", "NextElementFunc", "AttachmentFunc", "XmlStringArrayExprFunc", "ArrayToStringFunc", "EncodeFunc", "DecodeFunc", "XmlEncodeFunc", "XmlDecodeFunc", "Property"};

    public String toString() {
        if (this.opCode <= 0 || this.opCode >= opCodeNames.length) {
            return opCodeNames[0] + "(" + String.valueOf(this.opCode) + ")";
        }
        return opCodeNames[this.opCode];
    }

    public OpCode(int newOpCode) {
        this.opCode = newOpCode;
        if (this.opCode == -2) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == -1) {
            this.theOpCodeValue = -1;
        } else if (this.opCode == 1) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 2) {
            this.theOpCodeValue = -1;
        } else if (this.opCode == 3) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 4) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 5) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 6) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 7) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 8) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 9) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 10) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 12) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 13) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 14) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 15) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 16) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 17) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 18) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 19) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 20) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 21) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 22) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 23) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 24) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 25) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 26) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 27) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 28) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 29) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 30) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 31) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 32) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 33) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 34) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 35) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 36) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 37) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 38) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 39) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 40) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 41) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 42) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 43) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 44) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 45) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 46) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 47) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 48) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 49) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 50) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 51) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 52) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 53) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 54) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 55) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 56) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 57) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 58) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 59) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 60) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 61) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 62) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 63) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 64) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 65) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 66) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 67) {
            this.theOpCodeValue = 16;
        } else if (this.opCode == 68) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 69) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 70) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 71) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 72) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 73) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 74) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 75) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 76) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 77) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 78) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 79) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 80) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 81) {
            this.theOpCodeValue = -1;
        } else if (this.opCode == 82) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 83) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 84) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 85) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 86) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 87) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 88) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 89) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 90) {
            this.theOpCodeValue = -1;
        } else if (this.opCode == 91) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 92) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 93) {
            this.theOpCodeValue = -2;
        } else if (this.opCode == 94) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 95) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 96) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 97) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 98) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 99) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 100) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 101) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 102) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 103) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 104) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 105) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 106) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 107) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 108) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 109) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 110) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 111) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 112) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 113) {
            this.theOpCodeValue = 8;
        } else if (this.opCode == 114) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 115) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 116) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 117) {
            this.theOpCodeValue = 4;
        } else if (this.opCode == 118) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 119) {
            this.theOpCodeValue = 1;
        } else if (this.opCode == 120) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 121) {
            this.theOpCodeValue = -5;
        } else if (this.opCode == 122) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 123) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 124) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 125) {
            this.theOpCodeValue = 2;
        } else if (this.opCode == 126) {
            this.theOpCodeValue = 2;
        }
    }

    public int getOpCodeValue() {
        return this.theOpCodeValue;
    }

    public static void checkConversion(int oldDataType, int newDataType, boolean isConst) throws VWException {
        block0 : switch (oldDataType) {
            case 1: {
                switch (newDataType) {
                    case 1: 
                    case 8: {
                        break block0;
                    }
                    case 2: 
                    case 4: 
                    case 16: {
                        if (!isConst) break block0;
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                    default: {
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                }
            }
            case 8: {
                switch (newDataType) {
                    case 1: 
                    case 8: {
                        break block0;
                    }
                    case 2: 
                    case 4: 
                    case 16: {
                        if (!isConst) break block0;
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                    default: {
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                }
            }
            case 2: {
                switch (newDataType) {
                    case 2: 
                    case 32: 
                    case 64: 
                    case 128: 
                    case 512: {
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 8: 
                    case 16: {
                        if (!isConst) break block0;
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                    default: {
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                }
            }
            case 16: {
                switch (newDataType) {
                    case 16: {
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        if (!isConst) break block0;
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                    default: {
                        throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                    }
                }
            }
            case 4: {
                if (isConst && newDataType != 4) {
                    throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
                }
                switch (newDataType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        break block0;
                    }
                }
                throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
            }
            case 32: {
                switch (newDataType) {
                    case 2: 
                    case 32: {
                        break block0;
                    }
                }
                throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
            }
            case 64: {
                switch (newDataType) {
                    case 2: 
                    case 64: {
                        break block0;
                    }
                }
                throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
            }
            case 128: {
                switch (newDataType) {
                    case 2: 
                    case 128: {
                        break block0;
                    }
                }
                throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
            }
            case 512: {
                switch (newDataType) {
                    case 2: {
                        break block0;
                    }
                }
                throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
            }
            default: {
                throw new VWException("vw.api.VWOpCodeBadConvertType", "Invalid conversion data type.");
            }
        }
    }

    public int dispatch(Stack runStack, IFieldCollection mainFields, IFieldCollection alternateFields, Hashtable envData) throws Exception {
        switch (this.opCode) {
            case 10: {
                this.doValue(runStack);
                break;
            }
            case 28: {
                this.doNegate(runStack);
                break;
            }
            case 5: {
                this.doTrue(runStack);
                break;
            }
            case 6: {
                this.doFalse(runStack);
                break;
            }
            case 16: {
                this.doAnd(runStack);
                break;
            }
            case 15: {
                this.doOr(runStack);
                break;
            }
            case 17: {
                this.doNot(runStack);
                break;
            }
            case 18: {
                this.doEQ(runStack);
                break;
            }
            case 22: {
                this.doGE(runStack);
                break;
            }
            case 20: {
                this.doGT(runStack);
                break;
            }
            case 23: {
                this.doLE(runStack);
                break;
            }
            case 21: {
                this.doLT(runStack);
                break;
            }
            case 19: {
                this.doNE(runStack);
                break;
            }
            case 24: {
                this.doAdd(runStack);
                break;
            }
            case 25: {
                this.doSubtract(runStack);
                break;
            }
            case 26: {
                this.doMultiply(runStack);
                break;
            }
            case 27: {
                this.doDivide(runStack);
                break;
            }
            case 30: {
                this.doAbsFunc(runStack);
                break;
            }
            case 66: {
                this.doSystemDateFunc(runStack, envData);
                break;
            }
            case 67: {
                this.doSystemTimeFunc(runStack, envData);
                break;
            }
            case 33: {
                this.doMaxFunc(runStack);
                break;
            }
            case 32: {
                this.doMinFunc(runStack);
                break;
            }
            case 78: {
                this.doSizeOfFunc(runStack);
                break;
            }
            case 29: {
                this.doIntFunc(runStack);
                break;
            }
            case 31: {
                this.doModFunc(runStack);
                break;
            }
            case 83: {
                this.doAddToCollection(runStack);
                break;
            }
            case 68: {
                this.doCreateCollection(runStack);
                break;
            }
            case 34: {
                this.doLenFunc(runStack);
                break;
            }
            case 87: {
                this.doTrim1Func(runStack);
                break;
            }
            case 88: {
                this.doLTrim1Func(runStack);
                break;
            }
            case 89: {
                this.doRTrim1Func(runStack);
                break;
            }
            case 41: {
                this.doTrimFunc(runStack);
                break;
            }
            case 42: {
                this.doLTrimFunc(runStack);
                break;
            }
            case 43: {
                this.doRTrimFunc(runStack);
                break;
            }
            case 39: {
                this.doUpperFunc(runStack);
                break;
            }
            case 40: {
                this.doLowerFunc(runStack);
                break;
            }
            case 36: {
                this.doStrLocFunc(runStack);
                break;
            }
            case 44: {
                this.doRepeatFunc(runStack);
                break;
            }
            case 37: {
                this.doSubStr2Func(runStack);
                break;
            }
            case 82: {
                this.doSubStr3Func(runStack);
                break;
            }
            case 38: {
                this.doTranslateFunc(runStack);
                break;
            }
            case 35: {
                this.doStrInsFunc(runStack);
                break;
            }
            case 46: {
                this.doSubstituteFunc(runStack);
                break;
            }
            case 56: {
                this.doNumberToStringFunc(runStack);
                break;
            }
            case 71: {
                this.doBitAndFunc(runStack);
                break;
            }
            case 72: {
                this.doBitOrFunc(runStack);
                break;
            }
            case 73: {
                this.doBitNotFunc(runStack);
                break;
            }
            case 45: {
                this.doInSetFunc(runStack);
                break;
            }
            case 47: {
                this.doIsNumberFunc(runStack);
                break;
            }
            case 70: {
                this.doErrorEncodeFunc(runStack);
                break;
            }
            case 86: {
                this.doRandomFunc(runStack, envData);
                break;
            }
            case 85: {
                this.doUserIdFunc(runStack, envData);
                break;
            }
            case 57: {
                this.doAddSecondsFunc(runStack);
                break;
            }
            case 58: {
                this.doAddMinutesFunc(runStack);
                break;
            }
            case 59: {
                this.doAddHoursFunc(runStack);
                break;
            }
            case 60: {
                this.doAddDaysFunc(runStack);
                break;
            }
            case 61: {
                this.doAddMonthsFunc(runStack);
                break;
            }
            case 62: {
                this.doAddYearsFunc(runStack);
                break;
            }
            case 65: {
                this.doWeekDayFunc(runStack);
                break;
            }
            case 63: {
                this.doDaysBetweenFunc(runStack);
                break;
            }
            case 64: {
                this.doSecondsBetweenFunc(runStack);
                break;
            }
            case 69: {
                this.doHexFunc(runStack);
                break;
            }
            case 52: 
            case 54: {
                this.doTimeToStringFunc(runStack);
                break;
            }
            case 53: 
            case 55: {
                this.doStringToTimeFunc(runStack);
                break;
            }
            case 48: 
            case 49: {
                this.doIsTimeFunc(runStack);
                break;
            }
            case 94: {
                this.doDistBernoulliFunc(runStack, envData);
                break;
            }
            case 95: {
                this.doDistBetaFunc(runStack, envData);
                break;
            }
            case 96: {
                this.doDistBinomialFunc(runStack, envData);
                break;
            }
            case 97: {
                this.doDistExponentialFunc(runStack, envData);
                break;
            }
            case 98: {
                this.doDistGammaFunc(runStack, envData);
                break;
            }
            case 99: {
                this.doDistGeometricFunc(runStack, envData);
                break;
            }
            case 100: {
                this.doDistLognormalFunc(runStack, envData);
                break;
            }
            case 101: {
                this.doDistNormalFunc(runStack, envData);
                break;
            }
            case 102: {
                this.doDistPoissonFunc(runStack, envData);
                break;
            }
            case 103: {
                this.doDistUniformFunc(runStack, envData);
                break;
            }
            case 104: {
                this.doDistWeibullFunc(runStack, envData);
                break;
            }
            case 105: {
                this.doXmlInsertBeforeFunc(runStack);
                break;
            }
            case 106: {
                this.doXmlInsertAfterFunc(runStack);
                break;
            }
            case 107: {
                this.doXmlInsertChildFirstFunc(runStack);
                break;
            }
            case 108: {
                this.doXmlInsertChildLastFunc(runStack);
                break;
            }
            case 109: {
                this.doXmlRemoveFunc(runStack);
                break;
            }
            case 110: {
                this.doXmlRenameFunc(runStack);
                break;
            }
            case 111: {
                this.doXmlBooleanExprFunc(runStack);
                break;
            }
            case 112: {
                this.doXmlIntegerExprFunc(runStack);
                break;
            }
            case 113: {
                this.doXmlFloatExprFunc(runStack);
                break;
            }
            case 114: {
                this.doXmlStringExprFunc(runStack);
                break;
            }
            case 115: {
                this.doXmlTransformFunc(runStack);
                break;
            }
            case 116: {
                this.doIsWellFormedFunc(runStack);
                break;
            }
            case 117: {
                this.doIsValidXMLFunc(runStack);
                break;
            }
            case 118: {
                this.doElementCountFunc(runStack);
                break;
            }
            case 119: {
                this.doNextElementFunc(runStack);
                break;
            }
            case 120: {
                this.doAttachmentFunc(runStack);
                break;
            }
            case 121: {
                this.doXmlStringArrayExprFunc(runStack);
                break;
            }
            case 122: {
                this.doArrayToStringFunc(runStack);
                break;
            }
            case 123: {
                this.doEncodeFunc(runStack);
                break;
            }
            case 124: {
                this.doDecodeFunc(runStack);
                break;
            }
            case 125: {
                this.doXmlEncodeFunc(runStack);
                break;
            }
            case 126: {
                this.doXmlDecodeFunc(runStack);
                break;
            }
            default: {
                throw new VWException("vw.base.ExpressionExecution.BadOpCode", "***Opcode ({0}) not implemented.", this.toString());
            }
        }
        return -1;
    }

    private void doValue(Stack runStack) throws Exception {
        if (runStack.peek() instanceof ArrayList) {
            int nFieldType;
            String propertyName;
            CEObjectInfo ceObjectInfo;
            ArrayList theProperties = (ArrayList)runStack.pop();
            String fieldName = (String)runStack.pop();
            IFieldCollection fields = (IFieldCollection)runStack.pop();
            Object fieldValue = null;
            IField ceObjectField = fields.getField(fieldName);
            if (ceObjectField != null && theProperties.size() > 0 && (ceObjectInfo = ceObjectField.getCEObjectInfo()) != null && (fieldValue = ceObjectInfo.getPropertyValue(propertyName = (String)theProperties.get(0))) == null && (nFieldType = ceObjectInfo.getPropertyType(propertyName)) != -1) {
                fieldValue = this.defaultForCENullValue(nFieldType, ceObjectInfo.getPropertyIsArray(propertyName));
            }
            runStack.push(fieldValue);
        } else if (runStack.peek() instanceof String) {
            String fieldName = (String)runStack.pop();
            IFieldCollection fields = (IFieldCollection)runStack.pop();
            runStack.push(fields.getField(fieldName).getValue());
        } else if (runStack.peek() instanceof Integer) {
            Integer index = (Integer)runStack.pop();
            Object[] array = (Object[])runStack.pop();
            runStack.push(array[index]);
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidValueStack", "Value OpCode, bad stack");
        }
    }

    public Object defaultForCENullValue(int nFieldType, boolean bIsArray) throws VWException {
        switch (nFieldType) {
            case 4: {
                if (bIsArray) {
                    Boolean[] array = new Boolean[]{false};
                    return array;
                }
                return false;
            }
            case 2: {
                if (bIsArray) {
                    String[] array = new String[]{""};
                    return array;
                }
                return "";
            }
            case 8: {
                if (bIsArray) {
                    Double[] array = new Double[]{0.0};
                    return array;
                }
                return 0.0;
            }
            case 16: {
                if (bIsArray) {
                    Date[] array = new Date[]{new Date(Long.valueOf("-2000000000000"))};
                    return array;
                }
                return new Date(Long.valueOf("-2000000000000"));
            }
            case 1: {
                if (bIsArray) {
                    Integer[] array = new Integer[]{0};
                    return array;
                }
                return 0;
            }
        }
        throw new VWException("vw.base.ExpressionExecution.UnexpectedType", "Unexpected type for CE property value encountered during expression evaluation, type = \"{0}\".", nFieldType);
    }

    private void doNegate(Stack runStack) throws VWException {
        Object top = runStack.pop();
        if (top instanceof Integer) {
            runStack.push((Integer)top * -1);
        } else if (top instanceof Double) {
            runStack.push(new Double((Double)top * -1.0));
        } else {
            throw new VWException("vw.base.ExpressionExecution.NonNumericNegate", "Attempt to negate non-numeric value on stack");
        }
    }

    private void doTrue(Stack runStack) {
        runStack.push(true);
    }

    private void doFalse(Stack runStack) {
        runStack.push(false);
    }

    private void doAnd(Stack runStack) {
        Boolean bool1 = (Boolean)runStack.pop();
        Boolean bool2 = (Boolean)runStack.pop();
        runStack.push(bool1 != false && bool2 != false);
    }

    private void doOr(Stack runStack) {
        Boolean bool1 = (Boolean)runStack.pop();
        Boolean bool2 = (Boolean)runStack.pop();
        runStack.push(bool1 != false || bool2 != false);
    }

    private void doNot(Stack runStack) {
        runStack.push((Boolean)runStack.pop() == false);
    }

    private void doEQ(Stack runStack) {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push(((Integer)val1).intValue() == ((Integer)val2).intValue());
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() == (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 == (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push(((Double)val1).doubleValue() == ((Double)val2).doubleValue());
        } else {
            runStack.push(val1.equals(val2));
        }
    }

    private void doNE(Stack runStack) {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push(((Integer)val1).intValue() != ((Integer)val2).intValue());
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() != (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 != (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push(((Double)val1).doubleValue() != ((Double)val2).doubleValue());
        } else {
            runStack.push(!val1.equals(val2));
        }
    }

    private void doGT(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 > (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() > (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 > (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push((Double)val1 > (Double)val2);
        } else if (val1 instanceof String && val2 instanceof String) {
            runStack.push(((String)val1).compareTo(((String)val2).toString()) > 0);
        } else if (val1 instanceof Date && val2 instanceof Date) {
            runStack.push(((Date)val1).compareTo((Date)val2) > 0);
        } else if (val1 instanceof Boolean && val2 instanceof Boolean) {
            runStack.push((Boolean)val1 != false && (Boolean)val2 == false);
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doLT(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 < (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() < (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 < (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push((Double)val1 < (Double)val2);
        } else if (val1 instanceof String && val2 instanceof String) {
            runStack.push(((String)val1).compareTo(((String)val2).toString()) < 0);
        } else if (val1 instanceof Date && val2 instanceof Date) {
            runStack.push(((Date)val1).compareTo((Date)val2) < 0);
        } else if (val1 instanceof Boolean && val2 instanceof Boolean) {
            runStack.push((Boolean)val1 == false && (Boolean)val2 != false);
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doGE(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 >= (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() >= (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 >= (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push((Double)val1 >= (Double)val2);
        } else if (val1 instanceof String && val2 instanceof String) {
            runStack.push(((String)val1).compareTo(((String)val2).toString()) >= 0);
        } else if (val1 instanceof Date && val2 instanceof Date) {
            runStack.push(((Date)val1).compareTo((Date)val2) >= 0);
        } else if (val1 instanceof Boolean && val2 instanceof Boolean) {
            runStack.push((Boolean)val1 != false || (Boolean)val2 == false);
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doLE(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 <= (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() <= (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 <= (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push((Double)val1 <= (Double)val2);
        } else if (val1 instanceof String && val2 instanceof String) {
            runStack.push(((String)val1).compareTo(((String)val2).toString()) <= 0);
        } else if (val1 instanceof Date && val2 instanceof Date) {
            runStack.push(((Date)val1).compareTo((Date)val2) <= 0);
        } else if (val1 instanceof Boolean && val2 instanceof Boolean) {
            runStack.push((Boolean)val1 == false || (Boolean)val2 != false);
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doAdd(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 + (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push((double)((Integer)val1).intValue() + (Double)val2);
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push((Double)val1 + (double)((Integer)val2).intValue());
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push((Double)val1 + (Double)val2);
        } else if (val1 instanceof String && val2 instanceof String) {
            runStack.push(((String)val1).toString() + ((String)val2).toString());
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doSubtract(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 - (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push(new Double((double)((Integer)val1).intValue() - (Double)val2));
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push(new Double((Double)val1 - (double)((Integer)val2).intValue()));
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push(new Double((Double)val1 - (Double)val2));
        } else if (val1 instanceof Date && val2 instanceof Date) {
            runStack.push(Long.valueOf(((Date)val1).getTime() / 1000L - ((Date)val2).getTime() / 1000L).intValue());
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doMultiply(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 * (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push(new Double((double)((Integer)val1).intValue() * (Double)val2));
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push(new Double((Double)val1 * (double)((Integer)val2).intValue()));
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push(new Double((Double)val1 * (Double)val2));
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doDivide(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val2 instanceof Integer && (Integer)val2 == 0 || val2 instanceof Double && (Double)val2 == 0.0) {
            throw new VWException("vw.base.ExpressionExecution.DivideByZero", "Divide by zero error.");
        }
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 / (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push(new Double((double)((Integer)val1).intValue() / (Double)val2));
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push(new Double((Double)val1 / (double)((Integer)val2).intValue()));
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push(new Double((Double)val1 / (Double)val2));
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doAbsFunc(Stack runStack) throws VWException {
        Object number = runStack.pop();
        if (number instanceof Integer) {
            if ((Integer)number < 0) {
                number = -((Integer)number).intValue();
            }
        } else if (number instanceof Double) {
            if ((Double)number < 0.0) {
                number = new Double(-((Double)number).doubleValue());
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidAbsOperand", "Invalid operand for AbsFunc, " + number.getClass().toString());
        }
        runStack.push(number);
    }

    private void doSystemTimeFunc(Stack runStack, Hashtable envData) {
        if (envData != null && envData.get("CurrentTime") instanceof Date) {
            runStack.push((Date)envData.get("CurrentTime"));
        } else {
            runStack.push(new Date());
        }
    }

    private void doSystemDateFunc(Stack runStack, Hashtable envData) {
        Calendar today = Calendar.getInstance();
        if (envData != null && envData.get("CurrentTime") instanceof Date) {
            today.setTime((Date)envData.get("CurrentTime"));
        }
        today.set(13, 0);
        today.set(12, 0);
        today.set(10, 0);
        today.set(9, 0);
        runStack.push(today.getTime());
    }

    private void doMaxFunc(Stack runStack) throws VWException {
        Object val1 = runStack.pop();
        Object val2 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            if ((Integer)val1 > (Integer)val2) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            if ((double)((Integer)val1).intValue() > (Double)val2) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            if ((Double)val1 > (double)((Integer)val2).intValue()) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Double && val2 instanceof Double) {
            if ((Double)val1 > (Double)val2) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof String && val2 instanceof String) {
            if (((String)val1).compareTo(((String)val2).toString()) > 0) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Date && val2 instanceof Date) {
            if (((Date)val1).compareTo((Date)val2) > 0) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Boolean && val2 instanceof Boolean) {
            if (((Boolean)val1).booleanValue()) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doMinFunc(Stack runStack) throws VWException {
        Object val1 = runStack.pop();
        Object val2 = runStack.pop();
        if (val1 instanceof Integer && val2 instanceof Integer) {
            if ((Integer)val1 < (Integer)val2) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            if ((double)((Integer)val1).intValue() < (Double)val2) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            if ((Double)val1 < (double)((Integer)val2).intValue()) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Double && val2 instanceof Double) {
            if ((Double)val1 < (Double)val2) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof String && val2 instanceof String) {
            if (((String)val1).compareTo(((String)val2).toString()) < 0) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Date && val2 instanceof Date) {
            if (((Date)val1).compareTo((Date)val2) < 0) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else if (val1 instanceof Boolean && val2 instanceof Boolean) {
            if (!((Boolean)val1).booleanValue()) {
                runStack.push(val1);
            } else {
                runStack.push(val2);
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doSizeOfFunc(Stack runStack) throws Exception {
        if (!(runStack.peek() instanceof String) || runStack.size() < 2) {
            throw new VWException("vw.base.ExpressionExecution.SizeofBadStack", "Sizeof OpCode, bad stack");
        }
        String fieldName = (String)runStack.pop();
        IFieldCollection fields = (IFieldCollection)runStack.pop();
        runStack.push(((Object[])fields.getField(fieldName).getValue()).length);
    }

    private void doIntFunc(Stack runStack) throws VWException {
        Object top = runStack.pop();
        if (top instanceof Integer) {
            runStack.push(top);
        } else if (top instanceof Double) {
            runStack.push(((Double)top).intValue());
        } else {
            throw new VWException("vw.base.ExpressionExecution.IntNonNumeric", "Attempt to call int() on non-numeric value on stack");
        }
    }

    private void doModFunc(Stack runStack) throws VWException {
        Object val2 = runStack.pop();
        Object val1 = runStack.pop();
        if (val2 instanceof Integer && (Integer)val2 == 0 || val2 instanceof Double && (Double)val2 == 0.0) {
            throw new VWException("vw.base.ExpressionExecution.DivideByZero", "Divide by zero error.");
        }
        if (val1 instanceof Integer && val2 instanceof Integer) {
            runStack.push((Integer)val1 % (Integer)val2);
        } else if (val1 instanceof Integer && val2 instanceof Double) {
            runStack.push(new Double((double)((Integer)val1).intValue() % (Double)val2));
        } else if (val1 instanceof Double && val2 instanceof Integer) {
            runStack.push(new Double((Double)val1 % (double)((Integer)val2).intValue()));
        } else if (val1 instanceof Double && val2 instanceof Double) {
            runStack.push(new Double((Double)val1 % (Double)val2));
        } else {
            throw new VWException("vw.base.ExpressionExecution.InvalidOperandCombo", "Invalid operand combination for opcode {0}, {1} and {2}", this.toString(), val1.getClass().toString(), val2.getClass().toString());
        }
    }

    private void doCreateCollection(Stack runStack) {
        runStack.push(new Object[0]);
    }

    private void doAddToCollection(Stack runStack) {
        Object val = runStack.pop();
        Object[] array = (Object[])runStack.pop();
        Object[] newArray = (Object[])Array.newInstance(val.getClass(), array.length + 1);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        newArray[array.length] = val;
        runStack.push(newArray);
    }

    private void doLenFunc(Stack runStack) {
        String str = (String)runStack.pop();
        runStack.push(str.length());
    }

    private void doTrim1Func(Stack runStack) {
        String str;
        String newStr = str = (String)runStack.pop();
        runStack.push(newStr.trim());
    }

    private void doLTrim1Func(Stack runStack) {
        int i;
        String str = (String)runStack.pop();
        for (i = 0; i < str.length() && Character.isSpaceChar(str.charAt(i)); ++i) {
        }
        runStack.push(str.substring(i));
    }

    private void doRTrim1Func(Stack runStack) {
        int i;
        String str = (String)runStack.pop();
        for (i = str.length() - 1; i > 0 && Character.isSpaceChar(str.charAt(i)); --i) {
        }
        if (i <= 0) {
            runStack.push("");
        } else {
            runStack.push(str.substring(0, i + 1));
        }
    }

    private void doTrimFunc(Stack runStack) {
        char ch;
        int i;
        String stripChars = (String)runStack.pop();
        String str = (String)runStack.pop();
        for (i = 0; i < str.length() && stripChars.indexOf(ch = str.charAt(i)) != -1; ++i) {
        }
        str = str.substring(i);
        for (i = str.length() - 1; i > 0 && stripChars.indexOf(ch = str.charAt(i)) != -1; --i) {
        }
        if (i <= 0) {
            runStack.push("");
        } else {
            runStack.push(str.substring(0, i + 1));
        }
    }

    private void doLTrimFunc(Stack runStack) {
        char ch;
        int i;
        String stripChars = (String)runStack.pop();
        String str = (String)runStack.pop();
        for (i = 0; i < str.length() && stripChars.indexOf(ch = str.charAt(i)) != -1; ++i) {
        }
        runStack.push(str.substring(i));
    }

    private void doRTrimFunc(Stack runStack) {
        char ch;
        int i;
        String stripChars = (String)runStack.pop();
        String str = (String)runStack.pop();
        for (i = str.length() - 1; i > 0 && stripChars.indexOf(ch = str.charAt(i)) != -1; --i) {
        }
        if (i <= 0) {
            runStack.push("");
        } else {
            runStack.push(str.substring(0, i + 1));
        }
    }

    private void doUpperFunc(Stack runStack) {
        String str = (String)runStack.pop();
        runStack.push(str.toUpperCase());
    }

    private void doLowerFunc(Stack runStack) {
        String str = (String)runStack.pop();
        runStack.push(str.toLowerCase());
    }

    private void doStrLocFunc(Stack runStack) {
        String str2 = (String)runStack.pop();
        String str1 = (String)runStack.pop();
        runStack.push(str1.indexOf(str2, 0) + 1);
    }

    private void doRepeatFunc(Stack runStack) {
        Object oRepCount = runStack.pop();
        String str = (String)runStack.pop();
        StringBuffer result = new StringBuffer();
        int repCount = -1;
        repCount = oRepCount instanceof Integer ? ((Integer)oRepCount).intValue() : ((Double)oRepCount).intValue();
        if (repCount > 0) {
            for (int i = 0; i < repCount; ++i) {
                result.append(str);
            }
        }
        runStack.push(result.toString());
    }

    private void doSubStr3Func(Stack runStack) throws VWException {
        Object oLen = runStack.pop();
        Object oStart = runStack.pop();
        String str = (String)runStack.pop();
        int len = -1;
        int start = -1;
        len = oLen instanceof Integer ? ((Integer)oLen).intValue() : ((Double)oLen).intValue();
        start = oStart instanceof Integer ? ((Integer)oStart).intValue() : ((Double)oStart).intValue();
        if (start <= 0 || start + len - 1 > str.length()) {
            throw new VWException("vw.base.ExpressionExecution.BadStringIndexOrLength", "String index [{0}], or index plus length ({1}) is out of range", String.valueOf(start), String.valueOf(len));
        }
        runStack.push(str.substring(start - 1, start + len - 1));
    }

    private void doSubStr2Func(Stack runStack) throws VWException {
        Object oStart = runStack.pop();
        String str = (String)runStack.pop();
        int start = -1;
        start = oStart instanceof Integer ? ((Integer)oStart).intValue() : ((Double)oStart).intValue();
        if (start <= 0 || start > str.length() + 1) {
            throw new VWException("vw.base.ExpressionExecution.BadStringIndex", "String index [{0}] is out of range", String.valueOf(start));
        }
        runStack.push(str.substring(start - 1));
    }

    private void doTranslateFunc(Stack runStack) throws VWException {
        String to = (String)runStack.pop();
        String from = (String)runStack.pop();
        String srcStr = (String)runStack.pop();
        if (to.length() != from.length()) {
            throw new VWException("vw.base.ExpressionExecution.TranslateFromToMismatch", "Translate from ({0}) and to ({1}) strings are not the same length.", from, to);
        }
        StringBuffer result = new StringBuffer();
        int srcLen = srcStr.length();
        for (int i = 0; i < srcLen; ++i) {
            char ch = srcStr.charAt(i);
            int xlateIdx = from.indexOf(ch);
            if (xlateIdx == -1) {
                result.append(ch);
                continue;
            }
            result.append(to.charAt(xlateIdx));
        }
        runStack.push(result.toString());
    }

    private void doStrInsFunc(Stack runStack) throws VWException {
        Object oPos = runStack.pop();
        String insertStr = (String)runStack.pop();
        String targetStr = (String)runStack.pop();
        int pos = -1;
        pos = oPos instanceof Integer ? ((Integer)oPos).intValue() : ((Double)oPos).intValue();
        if (pos <= 0 || pos > targetStr.length() + 1) {
            throw new VWException("vw.base.ExpressionExecution.BadStringIndex", "String index [{0}] is out of range", String.valueOf(pos));
        }
        StringBuffer result = new StringBuffer();
        result.append(targetStr.substring(0, pos - 1)).append(insertStr).append(targetStr.substring(pos - 1));
        runStack.push(result.toString());
    }

    private void doSubstituteFunc(Stack runStack) {
        String desiredStr = (String)runStack.pop();
        String unwantedStr = (String)runStack.pop();
        String targetStr = (String)runStack.pop();
        StringBuffer result = new StringBuffer();
        int fromIdx = 0;
        int substIdx = 0;
        while (fromIdx < targetStr.length()) {
            substIdx = targetStr.indexOf(unwantedStr, fromIdx);
            if (substIdx == -1) {
                result.append(targetStr.substring(fromIdx));
                break;
            }
            result.append(targetStr.substring(fromIdx, substIdx)).append(desiredStr);
            fromIdx = substIdx + unwantedStr.length();
        }
        runStack.push(result.toString());
    }

    private void doNumberToStringFunc(Stack runStack) throws VWException {
        String mask = (String)runStack.pop();
        Object number = runStack.pop();
        DecimalFormat formatter = new DecimalFormat(mask);
        if (number instanceof Integer) {
            runStack.push(formatter.format(((Integer)number).longValue()));
        } else if (number instanceof Double) {
            runStack.push(formatter.format((Double)number));
        } else {
            throw new VWException("vw.base.ExpressionExecution.NumberToStringNonNumeric", "Attempt to call numbertostring() on non-numeric value on stack");
        }
    }

    private void doBitAndFunc(Stack runStack) throws VWException {
        Integer val2 = (Integer)runStack.pop();
        Integer val1 = (Integer)runStack.pop();
        runStack.push(val1 & val2);
    }

    private void doBitOrFunc(Stack runStack) throws VWException {
        Integer val2 = (Integer)runStack.pop();
        Integer val1 = (Integer)runStack.pop();
        runStack.push(val1 | val2);
    }

    private void doBitNotFunc(Stack runStack) throws VWException {
        Integer val = (Integer)runStack.pop();
        runStack.push(~val.intValue());
    }

    private void doInSetFunc(Stack runStack) {
        String setStr = (String)runStack.pop();
        String candidateStr = (String)runStack.pop();
        for (int i = 0; i < candidateStr.length(); ++i) {
            char ch = candidateStr.charAt(i);
            if (setStr.indexOf(ch) != -1) continue;
            runStack.push(false);
            return;
        }
        runStack.push(true);
    }

    private void doIsNumberFunc(Stack runStack) {
        String candidateStr = (String)runStack.pop();
        try {
            Double.parseDouble(candidateStr);
            runStack.push(true);
        }
        catch (Exception e) {
            runStack.push(false);
        }
    }

    private void doErrorEncodeFunc(Stack runStack) {
        Integer error_num = (Integer)runStack.pop();
        Integer function_num = (Integer)runStack.pop();
        Integer module_num = (Integer)runStack.pop();
        runStack.push(error_num + (function_num << 16) + (module_num << 24));
    }

    private void doRandomFunc(Stack runStack, Hashtable envData) throws VWException {
        int n = (Integer)runStack.pop();
        if (n < 2 || n > 32768) {
            throw new VWException("vw.base.ExpressionExecution.ValueOutOfRange", "Value out of range");
        }
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            runStack.push((int)(Math.round(Math.random() * (double)n) % (long)n));
        } else {
            runStack.push((int)(Math.round(((IDistributions)envData.get("SimDistributions")).random() * (double)n) % (long)n));
        }
    }

    private void doUserIdFunc(Stack runStack, Hashtable envData) {
        if (envData == null || envData.get("UserId") == null || !(envData.get("UserId") instanceof String)) {
            runStack.push("(NONE)");
        } else {
            runStack.push(envData.get("UserId").toString());
        }
    }

    private void doAddSecondsFunc(Stack runStack) throws VWException {
        Object addO = runStack.pop();
        int additional = 0;
        if (addO instanceof Integer) {
            additional = (Integer)addO;
        } else if (addO instanceof Double) {
            additional = ((Double)addO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(13, additional);
        runStack.push(cal.getTime());
    }

    private void doAddMinutesFunc(Stack runStack) throws VWException {
        Object addO = runStack.pop();
        int additional = 0;
        if (addO instanceof Integer) {
            additional = (Integer)addO;
        } else if (addO instanceof Double) {
            additional = ((Double)addO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(12, additional);
        runStack.push(cal.getTime());
    }

    private void doAddHoursFunc(Stack runStack) throws VWException {
        Object addO = runStack.pop();
        int additional = 0;
        if (addO instanceof Integer) {
            additional = (Integer)addO;
        } else if (addO instanceof Double) {
            additional = ((Double)addO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(10, additional);
        runStack.push(cal.getTime());
    }

    private void doAddDaysFunc(Stack runStack) throws VWException {
        Object addO = runStack.pop();
        int additional = 0;
        if (addO instanceof Integer) {
            additional = (Integer)addO;
        } else if (addO instanceof Double) {
            additional = ((Double)addO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(5, additional);
        runStack.push(cal.getTime());
    }

    private void doAddMonthsFunc(Stack runStack) throws VWException {
        Object addO = runStack.pop();
        int additional = 0;
        if (addO instanceof Integer) {
            additional = (Integer)addO;
        } else if (addO instanceof Double) {
            additional = ((Double)addO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(2, additional);
        runStack.push(cal.getTime());
    }

    private void doAddYearsFunc(Stack runStack) throws VWException {
        Object addO = runStack.pop();
        int additional = 0;
        if (addO instanceof Integer) {
            additional = (Integer)addO;
        } else if (addO instanceof Double) {
            additional = ((Double)addO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(1, additional);
        runStack.push(cal.getTime());
    }

    private void doWeekDayFunc(Stack runStack) {
        Date time = (Date)runStack.pop();
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int weekDayNumber = -1;
        switch (cal.get(7)) {
            case 1: {
                weekDayNumber = 0;
                break;
            }
            case 2: {
                weekDayNumber = 1;
                break;
            }
            case 3: {
                weekDayNumber = 2;
                break;
            }
            case 4: {
                weekDayNumber = 3;
                break;
            }
            case 5: {
                weekDayNumber = 4;
                break;
            }
            case 6: {
                weekDayNumber = 5;
                break;
            }
            case 7: {
                weekDayNumber = 6;
            }
        }
        runStack.push(weekDayNumber);
    }

    private void doDaysBetweenFunc(Stack runStack) {
        Date earlierTime = (Date)runStack.pop();
        Date laterTime = (Date)runStack.pop();
        runStack.push(Long.valueOf((laterTime.getTime() - earlierTime.getTime()) / 86400000L).intValue());
    }

    private void doSecondsBetweenFunc(Stack runStack) {
        Date earlierTime = (Date)runStack.pop();
        Date laterTime = (Date)runStack.pop();
        runStack.push(Long.valueOf((laterTime.getTime() - earlierTime.getTime()) / 1000L).intValue());
    }

    private void doHexFunc(Stack runStack) throws VWException {
        String hexString = (String)runStack.pop();
        int len = hexString.length();
        if ((len & 1) == 1) {
            throw new VWException("vw.base.ExpressionExecution.OddHexString", "String argument to the hex function must have an even length");
        }
        String hexDigits = "00112233445566778899AaBbCcDdEeFf";
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < len) {
            char hiNibble = hexString.charAt(i++);
            char loNibble = hexString.charAt(i++);
            if (hexDigits.indexOf(hiNibble) == -1 || hexDigits.indexOf(loNibble) == -1) {
                throw new VWException("vw.base.ExpressionExecution.BadHexString", "String argument to the hex function contains a character which is not a hexadecimal digit, either {0} or {1}", String.valueOf(hiNibble), String.valueOf(loNibble));
            }
            result.append((char)((hexDigits.indexOf(hiNibble) << 3) + hexDigits.indexOf(loNibble) / 2));
        }
        runStack.push(result.toString());
    }

    private void doIsTimeFunc(Stack runStack) throws VWException {
        String dtiMask = (String)runStack.pop();
        String timeStr = (String)runStack.pop();
        SimpleDateFormat maskDateFormatter = new SimpleDateFormat(this.convertDTImaskToJavaDateMask(dtiMask));
        maskDateFormatter.setLenient(false);
        if (maskDateFormatter.parse(timeStr, new ParsePosition(0)) != null) {
            runStack.push(true);
        } else {
            runStack.push(false);
        }
    }

    private void doStringToTimeFunc(Stack runStack) throws VWException {
        String dtiMask = (String)runStack.pop();
        String timeStr = (String)runStack.pop();
        SimpleDateFormat maskDateFormatter = new SimpleDateFormat(this.convertDTImaskToJavaDateMask(dtiMask));
        maskDateFormatter.setLenient(false);
        Date resultTime = maskDateFormatter.parse(timeStr, new ParsePosition(0));
        if (resultTime == null) {
            throw new VWException("vw.base.ExpressionExecution.InconsistentTimeFormat", "Inconsistencies between time string ''{0}'' and mask ''{1}'' ({2}))", timeStr, dtiMask, this.convertDTImaskToJavaDateMask(dtiMask));
        }
        runStack.push(resultTime);
    }

    private void doTimeToStringFunc(Stack runStack) throws VWException {
        String dtiMask = (String)runStack.pop();
        Date time = (Date)runStack.pop();
        SimpleDateFormat maskDateFormatter = new SimpleDateFormat(this.convertDTImaskToJavaDateMask(dtiMask));
        maskDateFormatter.setLenient(false);
        runStack.push(maskDateFormatter.format(time));
    }

    private String convertDTImaskToJavaDateMask(String DTI_mask) throws VWException {
        String separators = ",./-<>?:|^;\"[]{}_=@%+()*&# \t";
        StringBuffer resMask = new StringBuffer("");
        int HH_offset = -1;
        int offset = 0;
        int maskLength = DTI_mask.length();
        while (offset < maskLength) {
            if (separators.indexOf(DTI_mask.charAt(offset)) != -1) {
                resMask.append(DTI_mask.charAt(offset++));
                continue;
            }
            if (DTI_mask.regionMatches(offset, "ddd", 0, 3)) {
                resMask.append("DDD");
                offset += 3;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "dd", 0, 2)) {
                resMask.append("dd");
                offset += 2;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "mm", 0, 2)) {
                resMask.append("MM");
                offset += 2;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "month", 0, 5)) {
                resMask.append("MMMM");
                offset += 5;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "mon", 0, 3)) {
                resMask.append("MMM");
                offset += 3;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "yy", 0, 2)) {
                resMask.append("yy");
                offset += 2;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "w", 0, 1)) {
                resMask.append("EEE");
                ++offset;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "dayname", 0, 7)) {
                resMask.append("EEEE");
                offset += 7;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "day", 0, 3)) {
                resMask.append("EEE");
                offset += 3;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "hh", 0, 2)) {
                HH_offset = resMask.length();
                resMask.append("HH");
                offset += 2;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "tt", 0, 2)) {
                resMask.append("mm");
                offset += 2;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "ss", 0, 2)) {
                resMask.append("ss");
                offset += 2;
                continue;
            }
            if (DTI_mask.regionMatches(offset, "am", 0, 2)) {
                if (HH_offset != -1) {
                    resMask.replace(HH_offset, HH_offset + 2, "hh");
                }
                offset += 2;
                resMask.append("aa");
                continue;
            }
            throw new VWException("vw.base.ExpressionExecution.InvalidDTIMaskComponent", "The DTI mask ''{0}'' contains an invalid component, beginning at offset {1}. (offset is zero based)", DTI_mask, String.valueOf(offset));
        }
        return resMask.toString();
    }

    private void doDistBernoulliFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object probabilityO = runStack.pop();
        double probability = 0.0;
        if (probabilityO instanceof Integer) {
            probability = ((Integer)probabilityO).doubleValue();
        } else if (probabilityO instanceof Double) {
            probability = (Double)probabilityO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(((IDistributions)envData.get("SimDistributions")).bernoulli(probability));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistBetaFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object uboundO = runStack.pop();
        double ubound = 0.0;
        if (uboundO instanceof Integer) {
            ubound = ((Integer)uboundO).doubleValue();
        } else if (uboundO instanceof Double) {
            ubound = (Double)uboundO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object lboundO = runStack.pop();
        double lbound = 0.0;
        if (lboundO instanceof Integer) {
            lbound = ((Integer)lboundO).doubleValue();
        } else if (lboundO instanceof Double) {
            lbound = (Double)lboundO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object shape2O = runStack.pop();
        double shape2 = 0.0;
        if (shape2O instanceof Integer) {
            shape2 = ((Integer)shape2O).doubleValue();
        } else if (shape2O instanceof Double) {
            shape2 = (Double)lboundO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object shape1O = runStack.pop();
        double shape1 = 0.0;
        if (shape1O instanceof Integer) {
            shape1 = ((Integer)shape1O).doubleValue();
        } else if (shape1O instanceof Double) {
            shape1 = (Double)lboundO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).beta(shape1, shape2, lbound, ubound)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistBinomialFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object probabilityO = runStack.pop();
        double probability = 0.0;
        if (probabilityO instanceof Integer) {
            probability = ((Integer)probabilityO).doubleValue();
        } else if (probabilityO instanceof Double) {
            probability = (Double)probabilityO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object trailsO = runStack.pop();
        int trails = 0;
        if (trailsO instanceof Integer) {
            trails = (Integer)trailsO;
        } else if (trailsO instanceof Double) {
            trails = ((Double)trailsO).intValue();
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(((IDistributions)envData.get("SimDistributions")).binomial(trails, probability));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistExponentialFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object meanO = runStack.pop();
        double mean = 0.0;
        if (meanO instanceof Integer) {
            mean = ((Integer)meanO).doubleValue();
        } else if (meanO instanceof Double) {
            mean = (Double)meanO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).exponential(mean)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistGammaFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object scaleO = runStack.pop();
        double scale = 0.0;
        if (scaleO instanceof Integer) {
            scale = ((Integer)scaleO).doubleValue();
        } else if (scaleO instanceof Double) {
            scale = (Double)scaleO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object shapeO = runStack.pop();
        double shape = 0.0;
        if (shapeO instanceof Integer) {
            shape = ((Integer)shapeO).doubleValue();
        } else if (shapeO instanceof Double) {
            shape = (Double)shapeO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).gamma(shape, scale)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistGeometricFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object probabilityO = runStack.pop();
        double probability = 0.0;
        if (probabilityO instanceof Integer) {
            probability = ((Integer)probabilityO).doubleValue();
        } else if (probabilityO instanceof Double) {
            probability = (Double)probabilityO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(((IDistributions)envData.get("SimDistributions")).geometric(probability));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistLognormalFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object varianceO = runStack.pop();
        double variance = 0.0;
        if (varianceO instanceof Integer) {
            variance = ((Integer)varianceO).doubleValue();
        } else if (varianceO instanceof Double) {
            variance = (Double)varianceO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object meanO = runStack.pop();
        double mean = 0.0;
        if (meanO instanceof Integer) {
            mean = ((Integer)meanO).doubleValue();
        } else if (meanO instanceof Double) {
            mean = (Double)meanO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).lognormal(mean, variance)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistNormalFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object varianceO = runStack.pop();
        double variance = 0.0;
        if (varianceO instanceof Integer) {
            variance = ((Integer)varianceO).doubleValue();
        } else if (varianceO instanceof Double) {
            variance = (Double)varianceO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object meanO = runStack.pop();
        double mean = 0.0;
        if (meanO instanceof Integer) {
            mean = ((Integer)meanO).doubleValue();
        } else if (meanO instanceof Double) {
            mean = (Double)meanO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).normal(mean, variance)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistPoissonFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object meanO = runStack.pop();
        double mean = 0.0;
        if (meanO instanceof Integer) {
            mean = ((Integer)meanO).doubleValue();
        } else if (meanO instanceof Double) {
            mean = (Double)meanO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(((IDistributions)envData.get("SimDistributions")).poisson(mean));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistUniformFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object maxO = runStack.pop();
        double max = 0.0;
        if (maxO instanceof Integer) {
            max = ((Integer)maxO).doubleValue();
        } else if (maxO instanceof Double) {
            max = (Double)maxO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object minO = runStack.pop();
        double min = 0.0;
        if (minO instanceof Integer) {
            min = ((Integer)minO).doubleValue();
        } else if (minO instanceof Double) {
            min = (Double)minO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).uniform(min, max)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doDistWeibullFunc(Stack runStack, Hashtable envData) throws VWException {
        if (envData == null || envData.get("SimDistributions") == null || !(envData.get("SimDistributions") instanceof IDistributions)) {
            throw new VWException("vw.base.ExpressionExecution.MissingSimDistributions", "Attempt to call a statistical distribution function, without supplying an IDistributions implementation in the envData");
        }
        Object scaleO = runStack.pop();
        double scale = 0.0;
        if (scaleO instanceof Integer) {
            scale = ((Integer)scaleO).doubleValue();
        } else if (scaleO instanceof Double) {
            scale = (Double)scaleO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        Object shapeO = runStack.pop();
        double shape = 0.0;
        if (shapeO instanceof Integer) {
            shape = ((Integer)shapeO).doubleValue();
        } else if (shapeO instanceof Double) {
            shape = (Double)shapeO;
        } else {
            throw new VWException("vw.base.ExpressionExecution.ValueNotNumeric", "Unexpected non-numeric value on stack");
        }
        try {
            runStack.push(new Double(((IDistributions)envData.get("SimDistributions")).weibull(shape, scale)));
        }
        catch (Exception e) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            e.printStackTrace(ps);
            throw new VWException("vw.base.ExpressionExecution.ReThrownDistException", "Exception from distribution function : {0},\n{1}", e.getMessage(), buf.toString());
        }
    }

    private void doXmlInsertAfterFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doXmlInsertBeforeFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doXmlInsertChildFirstFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doXmlInsertChildLastFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doXmlRemoveFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doXmlRenameFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doXmlBooleanExprFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        runStack.push(false);
    }

    private void doXmlIntegerExprFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        runStack.push(0);
    }

    private void doXmlFloatExprFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        runStack.push(new Double(0.0));
    }

    private void doXmlStringExprFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        runStack.push("");
    }

    private void doXmlStringArrayExprFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.pop();
        runStack.push(new String[0]);
    }

    private void doXmlTransformFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        String p1 = (String)runStack.pop();
        runStack.push(p1);
    }

    private void doIsWellFormedFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.push(true);
    }

    private void doIsValidXMLFunc(Stack runStack) throws VWException {
        runStack.pop();
        runStack.pop();
        runStack.push(true);
    }

    private void doElementCountFunc(Stack runStack) throws VWException {
        if (runStack.peek() instanceof String && runStack.size() >= 2) {
            String arrayFieldName = (String)runStack.pop();
            IFieldCollection fields = (IFieldCollection)runStack.pop();
            int elemCount = 0;
            try {
                Object[] theArray = (Object[])fields.getField(arrayFieldName).getValue();
                if (theArray != null) {
                    int theType = fields.getField(arrayFieldName).getFieldType();
                    for (int i = 0; i < theArray.length; ++i) {
                        if ((theType == 1 || theType == 8 || theType == 4 || theType == 16) && theArray[i] != null) {
                            ++elemCount;
                            continue;
                        }
                        if (!(theType != 64 && theType != 2 && theType != 32 || theArray[i] == null || ((String)theArray[i]).equals(""))) {
                            ++elemCount;
                            continue;
                        }
                        if (theType != 32 || theArray[i] == null || ((String)theArray[i]).equals("") || ((String)theArray[i]).equals("||0|0||")) continue;
                        ++elemCount;
                    }
                }
                runStack.push(elemCount);
            }
            catch (Exception e) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(buf);
                e.printStackTrace(ps);
                throw new VWException("vw.base.ExpressionExecution.ReThrownException", "Exception rethrown from opcode dispatch routine : {0},\n{1}", e.getMessage(), buf.toString());
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.ElementCountBadStack", "Element Count OpCode, bad stack");
        }
    }

    private void doNextElementFunc(Stack runStack) throws VWException {
        if (runStack.peek() instanceof Integer && runStack.size() >= 3) {
            Integer theStart = (Integer)runStack.pop();
            String arrayFieldName = (String)runStack.pop();
            IFieldCollection fields = (IFieldCollection)runStack.pop();
            try {
                int elemNext;
                Object[] theArray = (Object[])fields.getField(arrayFieldName).getValue();
                if (theArray != null) {
                    int theType = fields.getField(arrayFieldName).getFieldType();
                    for (elemNext = theStart + 1; elemNext < theArray.length && (theType != 1 && theType != 8 && theType != 4 && theType != 16 || theArray[elemNext] == null) && (theType != 64 && theType != 2 && theType != 32 || theArray[elemNext] == null || ((String)theArray[elemNext]).equals("")) && (theType != 32 || theArray[elemNext] == null || ((String)theArray[elemNext]).equals("") || ((String)theArray[elemNext]).equals("||0|0||")); ++elemNext) {
                    }
                }
                if (elemNext > theArray.length) {
                    elemNext = 0;
                }
                runStack.push(elemNext);
            }
            catch (Exception e) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(buf);
                e.printStackTrace(ps);
                throw new VWException("vw.base.ExpressionExecution.ReThrownException", "Exception rethrown from opcode dispatch routine : {0},\n{1}", e.getMessage(), buf.toString());
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.NextElementBadStack", "Next Element OpCode, bad stack");
        }
    }

    private void doAttachmentFunc(Stack runStack) throws VWException {
        String fieldName = (String)runStack.pop();
        runStack.pop();
        runStack.push("<$FN_BEGIN_MIMEATT>PHONEY_EXPANDED_" + fieldName + "_EXPANDED_PHONEY<$FN_END_MIMEATT>");
    }

    private void doArrayToStringFunc(Stack runStack) throws VWException {
        if (runStack.size() >= 5) {
            String theSeparator = (String)runStack.pop();
            String theEnd = (String)runStack.pop();
            String theBegin = (String)runStack.pop();
            String arrayFieldName = (String)runStack.pop();
            IFieldCollection fields = (IFieldCollection)runStack.pop();
            try {
                Object[] theArray = (Object[])fields.getField(arrayFieldName).getValue();
                StringBuffer result = new StringBuffer("");
                result.append(theBegin);
                if (theArray != null && theArray.length > 0) {
                    for (int i = 0; i < theArray.length - 1; ++i) {
                        result.append(theArray[i].toString());
                        result.append(theSeparator);
                    }
                    result.append(theArray[theArray.length - 1].toString());
                }
                result.append(theEnd);
                runStack.push(result.toString());
            }
            catch (Exception e) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(buf);
                e.printStackTrace(ps);
                throw new VWException("vw.base.ExpressionExecution.ReThrownException", "Exception rethrown from opcode dispatch routine : {0},\n{1}", e.getMessage(), buf.toString());
            }
        } else {
            throw new VWException("vw.base.ExpressionExecution.ArrayToStringBadStack", "Array To String OpCode, bad stack ");
        }
    }

    private void doEncodeFunc(Stack runStack) throws VWException {
    }

    private void doDecodeFunc(Stack runStack) throws VWException {
    }

    private void doXmlEncodeFunc(Stack runStack) throws VWException {
        String theText = (String)runStack.pop();
        String theTranslation = XMLHelper.toXMLString(theText);
        runStack.push(theTranslation);
    }

    private void doXmlDecodeFunc(Stack runStack) throws VWException {
        String theText = (String)runStack.pop();
        String theTranslation = XMLHelper.convertXMLChars(theText);
        runStack.push(theTranslation);
    }
}

